#pragma once

#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream.>
#include "tools.h"
#include "contentlist.h"
#include "xmedia.h"

using namespace std;
extern int ToDisplay;
extern bool ShowFavs;
extern bool ShowRecent;
extern wstring GenreDisp;
extern ContentItem * CurentGame;
extern ContentItems * items;

typedef struct
{
    int iVal1;
    int iVal2;
}
MyMessageFirstStruct;

#define XM_LIST_REFRESH  XM_USER

#define XUI_ON_XM_LIST_REFRESH(MemberFunc)\
    if (pMessage->dwMessage == XM_LIST_REFRESH)\
    {\
		return MemberFunc(pMessage->bHandled);\
    }

class CGamesList : CXuiListImpl
{
public:

    XUI_IMPLEMENT_CLASS( CGamesList, L"GamesList", XUI_CLASS_LIST );

	XUI_BEGIN_MSG_MAP()
		XUI_ON_XM_INIT(OnInit)
		XUI_ON_XM_GET_SOURCE_TEXT(OnGetSourceDataText)
		XUI_ON_XM_GET_ITEMCOUNT_ALL(OnGetItemCountAll)
		XUI_ON_XM_GET_SOURCE_IMAGE(OnGetSourceDataImage)
		XUI_ON_XM_LIST_REFRESH( OnListRefresh )
	XUI_END_MSG_MAP()

	//LIST_DATA m_ListData;
	    
	HRESULT OnInit(XUIMessageInit *pInitData, BOOL& bHandled);
	HRESULT OnGetSourceDataText(XUIMessageGetSourceText *pGetSourceTextData, BOOL& bHandled);
	HRESULT OnGetItemCountAll(XUIMessageGetItemCount *pGetItemCountData, BOOL& bHandled);
	HRESULT OnGetSourceDataImage(XUIMessageGetSourceImage *pGetSourceImageData,  BOOL& bHandled);
	HRESULT OnListRefresh( BOOL& bHandled );
};

class CScnGames : public CXuiSceneImpl
{

protected:
    // Message map.
	CXuiList m_list;
	CXuiTextElement m_title;
	CXuiImageElement m_titleicon; //MATTIE: adding title icon
	CXuiTextElement m_genre;
	CXuiImageElement m_cover;
	CXuiImageElement m_ss1;
	CXuiImageElement m_ss2;
	CXuiImageElement m_background;
	CXuiTextElement m_desc;
//	CXuiTextElement m_freemem;
	CXuiTextElement m_gametitle;
	CXuiControl m_genrebutton;
	CXuiControl m_xbutton;
	CXuiControl m_lb;
	CXuiControl m_rb;
	CXuiVideo m_video;
	CXuiElement m_videoback;
	CXuiTextElement m_date;
	CXuiTextElement m_time;
	CXuiTextElement m_datetime;
	CXuiControl m_BackBtn;
	CXuiControl m_pcbtn;

	CXuiElement missingElementTest;
	CXuiElement m_BP;
	CXuiElement m_BP2;

	CXuiVideo m_fullpreview;
	CXuiElement m_fullpreviewbg;
	CXuiControl m_fullscreenbutton;

	IXMediaXmvPlayer* xmvPlayer;

	XUI_BEGIN_MSG_MAP()
        XUI_ON_XM_INIT( OnInit )
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
        XUI_ON_XM_NOTIFY_SELCHANGED( OnNotifySelChanged )
		XUI_ON_XM_TIMER( OnTimer )
		XUI_ON_XM_DESTROY( OnDestroy )
	XUI_END_MSG_MAP()

    //----------------------------------------------------------------------------------
    // Performs initialization tasks - retreives controls.
    //----------------------------------------------------------------------------------
    HRESULT OnInit( XUIMessageInit* pInitData, BOOL& bHandled );
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );
	HRESULT OnNotifySelChanged( HXUIOBJ hObjSource, XUINotifySelChanged* pNotifySelChangedData, BOOL& bHandled );
	HRESULT OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled );
	HRESULT OnDestroy();
public:
	void ListSel(int curSel);
	void KillLoadingTimers();
	void KillFullScreen();
	void ViewFullScreen();

    // Define the class. The class name must match the ClassOverride property
    // set for the scene in the UI Authoring tool.
    XUI_IMPLEMENT_CLASS( CScnGames, L"ScnGames", XUI_CLASS_TABSCENE )
};
